﻿using System;
using System.Collections.Generic;
using System.IO;

namespace LazyEnumeration
{
    // Listing 7-34. Leniwe przetwarzanie dużego zbioru danych z wolnym dostępem.
    class Program
    {
        static IEnumerable<string> GetAllFilesInDirectory(string directoryPath)
        {
            IEnumerable<string> files = null;
            IEnumerable<string> subdirectories = null;
            try
            {
                files = Directory.EnumerateFiles(directoryPath);
                subdirectories = Directory.EnumerateDirectories(directoryPath);
            }
            catch (UnauthorizedAccessException)
            {
                Console.WriteLine("Brak prawa dostępu do: " + directoryPath);
            }
            if (files != null)
            {
                foreach (string file in files)
                {
                    yield return file;
                }
            }
            if (subdirectories != null)
            {
                foreach (string subdirectory in subdirectories)
                {
                    foreach (string file in GetAllFilesInDirectory(subdirectory))
                    {
                        yield return file;
                    }
                }
            }
        }
        static void Main(string[] args)
        {
            // Zmień wartość true na false by wykonać drugi przykład.
#if true
            foreach (string file in GetAllFilesInDirectory(@"c:\"))
            {
                Console.WriteLine(file);
            }
#else
            // Listing 7-35. Łączenie leniwych enumeracji w łańcuch.
            IEnumerable<string> allFiles = GetAllFilesInDirectory(@"c:\");
            IEnumerable<string> numberedFiles = AddNumbers(allFiles);
            foreach (string file in numberedFiles)
            {
                Console.WriteLine(file);
            }
#endif
        }

        static IEnumerable<string> AddNumbers(IEnumerable<string> names)
        {
            int i = 0;
            foreach (string currentName in names)
            {
                yield return string.Format("{0}: {1}", i, currentName);
                i += 1;
            }
        }

    }
}
